function mat_rs = resize(mat, Nx, Nz, interp)
%RESIZE     Resize a matrix using interp2.
%
% DESCRIPTION:
%       Resize a matrix using interp2
%
% USAGE:
%       mat_rs = resize(mat, Nx, Nz)
%
% INPUTS:
%       mat         - matrix to resize
%       Nx          - desired number of pixels in the x (column) direction
%       Nz          - desired number of pixels in the z (row) direction
%
% OPTIONAL INPUTS:
%       interp      - interpolation mode used by interp2 
%                     (default = 'linear')
%
% OUTPUTS:
%       mat_rs      - resized matrix
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 8th July 2009
%       last update - 17th July 2009
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)
%
% See also interp2

% check the input is two-dimensional
if numDim(mat) ~= 2
    error('Input matrix must be two-dimensional');
end

% check for interpolation mode input
if nargin < 4
    interp = 'linear';
end

% extract the actual number of pixels from the size of the matrix
[Nz_input Nx_input] = size(mat);

% check the size is different to the input size
if Nx_input ~= Nx || Nz_input ~= Nz 

    % resize the input matrix to the desired number of pixels
    mat_rs = interp2(0:1/(Nx_input - 1):1, (0:1/(Nz_input - 1):1)', mat, 0:1/(Nx - 1):1, (0:1/(Nz - 1):1)', interp);
    
else
    mat_rs = mat;
end